# PHP GBIF client

First attempt of a PHP client for the [GBIF API](https://www.gbif.org/developer/summary). See its sibling projects in [R](https://github.com/ropensci/rgbif), [Python](https://github.com/sckott/pygbif) and [Ruby](https://github.com/sckott/gbifrb). Only occurrences (search an retrieval) are currently supported, but features will be added if this project gets enough funding.

A [Drupal module](https://www.drupal.org/project/gbif2) uses this client to enable users to list GBIF occurrences with the Views module on their websites.

## Use

### Get an occurrence knowing its ID (key)

```
<?php

use ResTelae\Gbif\Occurrences;

$occ = new Occurrences();
// Returns an array of results.
$occ->get(2550051996);
```

### Search

```
<?php

use ResTelae\Gbif\Occurrences;

$occ = new Occurrences();

// Returns an array of results.
$occ->search(['taxonKey' => 3329049]);

// Search by dataset key.
$occ->search([
  'datasetKey' => '7b5d6a48-f762-11e1-a439-00145eb45e9a',
  'limit' =>20,
]);

```

See src/Occurrences.php for more information.
